#include "devcoons-streaming.h"

	using namespace cv;

	using namespace std;

	void * devcoonsStreaming::FramesToNetwork(void * threadid)
	{
		#ifdef STREAMING_DEBUG
		
			printf("Frames To Network [thread] :: Started\n");
		
		#endif
		
		Mat frame;
		
		char * data;
		
		udp_message_t message;
		
		int remain_data, fps, delay;
		
		struct timespec t_begin, t_end;

		fps = 1000000 / 24;	// currently fixed at 15fps
		
		for( ;; )
		{
			clock_gettime(CLOCK_MONOTONIC, &t_begin);
				
			while (frames.empty() == true)
			
				usleep(10000);
						
			frame = frames.front();
		
			frames.pop();
			
			remain_data = frame.total() * frame.elemSize();
			
			message.width = multimedia_configuration.width;
			
			message.height = multimedia_configuration.height;
			
			message.frames = (remain_data / MAX_PACKET_DATA) ;
		
			message.frame = 0;
			
			message.format = (char)frame.type();
			
			data = (char*) frame.data;
			
			
			
			while(remain_data)
			{
				message.frame++;
				
				int copy = remain_data > MAX_PACKET_DATA ? MAX_PACKET_DATA : remain_data;
				
				memcpy(message.data, data, copy);
				
				data+=copy;
				
				remain_data-=copy;
				
				sendto(socket_id,(char*)&message, copy + 12,0,(struct sockaddr *)&network_configuration,sizeof(network_configuration));

				usleep(3300);
			}

			clock_gettime(CLOCK_MONOTONIC, &t_end);
			
			delay =  fps - (( (t_end.tv_sec - t_begin.tv_sec) ) * 1000000 + (( t_end.tv_nsec/1000 - t_begin.tv_nsec/1000 )));
			
			usleep(delay <= 0 ? 25: delay);
		
			frame.release();
			
		}
	
		#ifdef STREAMING_DEBUG
		
			printf(" FramesToNetwork :Unexpected error;\n");
		
		#endif
	
		return (void*)0;
	}
